if (typeof(browser) == "undefined") {
    browser = chrome;
}

var options = {
    pluginContentVersion: 2.0,
    minUiVersion: 1.0
};

var commandList = new Array();
var inCall = false;
var runningCommand;

var commandMap = {
    getLocation: {
        param1: "",
        param2: "",
        resultHandler: function (result) {
            setFormValue("deviceId", result);
        },
        nextCommand: "makeSign"
    },
    setDeviceType: {
        param1: function () {
            return options.deviceType;
        },
        param2: "",
        resultHandler: function (result) {
        },
        nextCommand: "getDeviceType"
    },
    getDeviceType: {
        param1: "",
        param2: "",
        resultHandler: function (result) {
            setFormValue("deviceType", result);
        },
        nextCommand: "getLocation"
    },
    makeSign: {
        param1: function () {
            return options.hash;
        },
        param2: "",
        resultHandler: function (result) {
            setFormValue("signedData", result);
        },
        nextCommand: "getLastError"
    },
    getLastError: {
        param1: "",
        param2: "",
        resultHandler: function (result) {
            var encode = setFormValue("ecode", result);
            if (-10 == encode && typeof options.url != "undefined") {
                window.location = options.url;
            }
            var res = evalSignResult(encode);
            if (res) {
                processCommandByKey("getNonstandardChars", true);
            } else {
                document.getElementById("authenticateLink").click();
            }
        }
    },
    getNonstandardChars: {
        param1: "",
        param2: "",
        resultHandler: function (result) {
            setFormValue("nonstandard", result);
            document.getElementById("authenticateLink").click();
        }
    },
    changePin: {
        param1: "",
        param2: ""
    }
};

window.addEventListener(
    "message",
    function (event) {
        // We only accept messages from ourselves
        if (event.source != window) {
            return;
        }
        if (typeof event.data != "undefined") {
            if (typeof event.data.command != "undefined") {
                console.log("message event has been received.");
                console.log(event);
                if (typeof event.data.uiVersion != "undefined") {
                    if (event.data.uiVersion < options.minUiVersion) {
                        console.log("invalid uiVersion:" + event.data.uiVersion + ", minUiVersion:" + options.minUiVersion);
                        window.alert("Frissítse a plugin-t, Please upgrade the plugin");
                        return false;
                    }
                }
                console.log("Execute command: " + event.data.command +
                    " param1:" + event.data.param1 + " param2:" + event.data.param2);

                if (typeof event.data.uiVersion == "undefined") {
                    console.log("missing uiVersion in postMessage");
                    return false;
                }

                options.url = event.data.url;
                commandList = new Array();//Törli az előző műveleteket!!!
                options.signMessages = (typeof event.data.signMessages == "undefined" ? [] : event.data.signMessages);
                var captionList = (typeof event.data.captionList == "undefined" ? [] : event.data.captionList);
                //push messages to the end
                for (key in captionList) {
                    processCommandByDefinition({command: "setParam", param1: encodeB64(key), param2: encodeB64(captionList[key])});
                }
                if (event.data.command == "makeSign") {
                    if (typeof event.data.param1 != "undefined") {
                        options.hash = encodeB64(event.data.param1);
                    }
                    if (typeof event.data.param2 != "undefined") {
                        options.deviceType = encodeB64(event.data.param2);
                    }
                    processCommandByKey("setDeviceType");
                } else if (event.data.command == "changePin") {
                    processCommandByKey("changePin");
                } else if (event.data.command == "checkPlugin") {
                    sendPluginInfo(event);
                }
                console.log(options);
            }
        }
    },
    false
);

var processCommandByKey = function (commandKey, forceNext) {
    var command = commandMap[commandKey];
    if (!command) {
        throw "not found command by key " + commandKey;
    }
    command.command = commandKey;
    processCommandByDefinition(command, forceNext);
    nextCommand();
};

var processCommandByDefinition = function (command, forceNext) {
    if (forceNext) {
        commandList.unshift(command);
    } else {
        commandList.push(command);
    }
    nextCommand();
};

var handleResult = function (response) {
    if (!check(response, runningCommand.command)) {
        return false;
    }
    if (runningCommand.resultHandler) {
        runningCommand.resultHandler(response);
    }
    if (runningCommand.nextCommand) {
        processCommandByKey(runningCommand.nextCommand, true);
    }
    runningCommand = null;
    inCall = false;
    nextCommand();
    return true;
};

var nextCommand = function () {
    if (inCall) {
        return false;
    }
    if (commandList.length == 0) {
        return false;
    }
    inCall = true;
    //get the first message and remove
    runningCommand = commandList.shift();

    browser.runtime.sendMessage(
        {command: runningCommand.command, param1: getIfFunction(runningCommand.param1), param2: getIfFunction(runningCommand.param2)},
        handleResult
    );
    return true;
};

var getIfFunction = function (v) {
    if (typeof v === "function") {
        return v();
    } else {
        return v;
    }
};

var evalSignResult = function (p_ec) {
    if ("1" != p_ec) {
        if ("-10" != p_ec) {
            alert(getSignMessage(p_ec));
        }
        return false;
    }
    return true;
};

var getSignMessage = function (p_ec) {
    if (p_ec) {
        if ("-1" == p_ec)
            return getMsg(0);
        if ("-4" == p_ec)
            return getMsg(1);
        if ("-7" == p_ec)
            return getMsg(2);
    }
    return getMsg(3);
};


var getMsg = function (p_idx) {
    return options.signMessages[p_idx];
}


var setFormValue = function (formId, response) {
    var p_form = document.getElementById("deviceform");
    if (p_form == null) {
        throw "not found form";
    }
    var result = decodeB64(response.result);
    p_form[formId].value = result;
    console.log("TODO Set form " + formId + ": " + result);
    return result;
};

var encodeB64 = function (text) {
    return CryptoJS.enc.Base64.stringify(CryptoJS.enc.Utf8.parse(text));
}

var decodeB64 = function (text) {
    return CryptoJS.enc.Base64.parse(text).toString(CryptoJS.enc.Utf8);
}

var check = function (response, nameAndFunction) {
    if (typeof response == "undefined") {
        console.log("error in " + nameAndFunction + " response, response is missing");
        window.alert("A K&H e-bank használatához telepített bővítmény valamint megfelelően telepített eBank program szükséges. Kérjük olvassa el a telepítési útmutatót!");
        return false;
    }
    console.log("Received response from background for " + nameAndFunction + ": " + JSON.stringify(response));
    if (typeof response.errorCode == "undefined") {
        console.log("error in " + nameAndFunction + " response, errorCode is missing");
        window.alert("Hiba történt! no errorCode");
        return false;
    }
    if (response.errorCode != 0) {
        console.log("error in " + nameAndFunction + " response, errorCode:" + response.errorCode + (typeof response.errorText == "undefined" ? ", no errorText" : ", errorText:" + response.errorText));
        window.alert("Hiba történt! " + response.errorCode);
        return false;
    }

    if (typeof response.result == "undefined") {
        console.log("error in " + nameAndFunction + " response, result is missing");
        window.alert("Hiba történt! no result");
        return false;
    }

    return true;
};

function sendPluginInfo(event) {
    event.source.postMessage({
        related: event.data.command,
        pluginContentVersion: options.pluginContentVersion,
        commandId: event.data.commandId
    }, event.origin);
}

console.log("ebank plugin has been set up.");


/****************************/
//function makeSignEvent(e) {
//    var signMessages = new Array("Nincs használható kártyaolvasó","Nincs kártya az olvasóban!","Hibás tanúsítvány!","Kártya olvasási hiba!\nEllenőrizze a kártyán szereplő dátumot (hó/év)!\nKérjük, a csere miatt fáradjon be bármelyik bankfiókunkba!");
//
//    var captionList = {};
//    captionList["ATTEMPTS_LEFT"]="kísérlet maradt";
//    captionList["BAD_PIN"]="hibás PIN";
//    captionList["BTN_CANCEL"]="mégsem";
//    captionList["BTN_OK"]="rendben";
//    captionList["EBANK_CAPTION"]="K&H e-bank";
//    captionList["EBANK_CAPTION_CHANGE_PIN"]="K&H e-bank – PIN kód módosítás";
//    captionList["ENTER_PIN"]="PIN kód:";
//    captionList["ERROR"]="ERROR";
//    captionList["NEWPIN_NAME"]="új:";
//    captionList["NEW_PIN"]="új PIN kód:";
//    captionList["OLDPIN_NAME"]="jelenlegi:";
//    captionList["OLD_PIN"]="jelenlegi PIN kód:";
//    captionList["PIN_CHANGE_OK"]="PIN kód módosítás sikeres";
//    captionList["PIN_MISMATCH"]="a két PIN eltérő";
//    captionList["PIN_TO_BE_CHANGED"]="Kérjük, hogy a token első használatát megelőzően módos...";
//    captionList["REENTER_NAME"]="megerősítés";
//
//    window.postMessage({ command: "makeSign", param1: "NDZiNjdmNDUtODJmYy00ZWZiLWEwYzgtMzkxY2EwZGQ4MTA2", param2: "CHIPCARD", uiVersion: 1, captionList: captionList, signMessages: signMessages}, "*");
//
//}
//
///*
//Add notifyExtension() as a listener to click events.
//*/
//window.addEventListener("click", makeSignEvent);
